import java.util.ArrayList;
import java.util.ListIterator;

public class EratosthenesLoesung {
  public static void main(String[] args) {
    // Zahlen 2..10000 einfuegen
    ArrayList<Integer> list = new ArrayList<Integer>();
    for (int i = 2; i <= 10000; i++) {
      list.add(i);
    }

    ListIterator<Integer> iterator = list.listIterator();
    while (iterator.hasNext()) {
      Integer zahl = iterator.next();
      // Probiere alle vorherigen Primzahlen als Teiler
      for (Integer teiler : list) {
        // Wenn der zu pruefende Teiler schon groesser als 
        // die Quadratwurzel ist, muss es eine Primzahl sein
        if (teiler > Math.sqrt(zahl))
          break;
        // Zahlen mit Teiler sind keine Primzahlen und
        // werden daher hier entfernt
        if (zahl % teiler == 0) {
          iterator.remove();
          break;
        }
      }
    }

    // Alle verbliebenen Zahlen sind Primzahlen
    for (Integer primzahl : list)
      System.out.println(primzahl);
  }
}